﻿
Partial Class wishlist
    Inherits System.Web.UI.Page

    'page header - declares constants used in the code
    'create an instance of the site infor class to store important data about the site
    Dim ThisSite As New SiteInfo
    'this constant is used to test if no item has been selected in the list
    Const NO_ITEM As Integer = -1
    'used to store the details of the current user
    Dim TheCurrentUser As New SwapShopUser

    Protected Sub btnDone_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnDone.Click
        'redirect back to the main page
        Response.Redirect("default.aspx")
    End Sub

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        'when the page loads display the wish list
        Call DisplayWishList()
        'get the site info
        ThisSite = Session("ThisSite")
    End Sub

    Sub DisplayWishList()
        'open a connection to the wish list table
        Dim WishList As New DatabaseTable("dvd.mdb", "select * from wishlist order by description", "#PN", "#PW")
        'var to store a single wish list item
        Dim AnItem As String
        'var to store the number of items in the wish list
        Dim ListCount As Integer
        'counter for the loop
        Dim Counter As Integer
        'clear the list box
        lstWishList.Items.Clear()
        'get the number of items in the wish list table
        ListCount = WishList.Count
        'loop through each item
        For Counter = 0 To ListCount - 1
            'get the description of the item
            AnItem = WishList.RecordNumber(Counter).Item("Description")
            'add it to the list
            lstWishList.Items.Add(AnItem)
        Next
    End Sub
End Class
